---
type: index
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# 20.0.4 - Propagation Patterns (index)

> Observational diagnostics over network structure. "Chains" are paths; patterns capture how difference propagates and fails.

---

## Pattern Framework

| Pattern | Description | Key Diagnostic |
|---------|-------------|----------------|
| [[Path (chain) (pattern)]] | Single-route flow | Path integrity |
| [[Multi-path (redundant) (pattern)]] | Parallel routes | Route diversity |
| [[Cycle (feedback loop) (pattern)]] | Closed loop | Loop stability |
| [[Cascade (pattern)]] | Chain reaction | Spread control |
| [[Bridge / Articulation (pattern)]] | Critical link | Link resilience |

Each pattern provides:
- Technical and humane diagnostic criteria
- Scale-dependent manifestations
- Flow behavior patterns
- Stability conditions

---

## Core References

Primitives:
- [[Form]]
- [[Field]]
- [[Structure]]

Anchors:
- [[ε — Difference Resolution Quantum (constant)]]
- [[c — Difference Propagation Limit (constant)]]
- [[π — Closure Geometry Ratio (constant)]]
- [[φ — Asymmetric Stabilization Ratio (constant)]]

Modulators:
- [[∇S — Structure Differentiation Gradient (Sarkisian)]]
- [[λV — Void Resonance Threshold (Volozhina)]]
- [[ψA — Awareness Phase Coherence Anchor (Aiza)]]